package gov.va.med.mhv.integration.phr.service;

import gov.va.med.mhv.integration.phr.message.MessageProcessor;

import java.util.Date;

/**
 * User: Rob Murtha
 */
public abstract class BasePhrProcessor implements PhrProcessor, PolicyControl, MessageProcessor {
    
	protected StagingService stagingService;
    protected TrackingService trackingService;
    protected ProcessingPolicy processingPolicy;
    protected long maxRetries = 10;
    protected long retryDelay = 60* 1000 * 5;

    public void setProcessingPolicy(ProcessingPolicy policy) {
        this.processingPolicy=policy;
    }

    public ProcessingPolicy getProcessingPolicy() {
        return this.processingPolicy;
    }

    public boolean isAllowed(Date lastProcessed) {
        return this.getProcessingPolicy()== null ? true
                : this.getProcessingPolicy().isAllowed(lastProcessed);
    }

    public void setTrackingService(TrackingService trackingService) {
        this.trackingService = trackingService;
    }

    public TrackingService getTrackingService() {
    	return this.trackingService;
    }

    public StagingService getStagingService() {
		return stagingService;
	}
    
    public void setStagingService(StagingService stagingService) {
		this.stagingService = stagingService;
	}

    public long getMaxRetries() {
        return maxRetries;
    }

    public void setMaxRetries(long maxRetries) {
        this.maxRetries = maxRetries;
    }

    public long getRetryDelay() {
        return retryDelay;
    }

    public void setRetryDelay(long retryDelay) {
        this.retryDelay = retryDelay;
    }
}
